package gov.va.med.mhv.calendar.dto;

import gov.va.med.mhv.calendar.enums.HourEnumeration;
import gov.va.med.mhv.calendar.enums.MinuteEnumeration;
import gov.va.med.mhv.calendar.util.CommonUtility;

import java.util.Date;

import org.primefaces.model.DefaultScheduleEvent;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class MHVEventModel extends DefaultScheduleEvent {
	
	private static final long serialVersionUID = 2608117555236474736L;
	
	private String eventName;
	private String location;
	private Long eventId;
	
	
	//fields specific to personal event
	private String description;
	private String repeatInterval;
	private Date repeatEndDate;
	private Date beginDate;
	private Date finishDate;
	private String startHour;
	private String startMinute;
	private String endHour;
	private String endMinute;


	
	//fields specific to appointments
	private String clinic;
	private String clinicPhone;
	private String status;
	
	//specific to task
	private String time;
	
	private String eventType;
	
	
	
    public MHVEventModel(){
		
	}
	public MHVEventModel(String title, Date start, Date end) {
    	super(title,start,end);
	}
	
	@JsonIgnore
	public String getDisplayTime(){
	   String time=null;	
	   String beginTime=null;
	   String endTime=null;
	   if(isAllDay()){
		  return "All day event"; 
	   }
	   try{
		    beginTime=CommonUtility.dateToString(getStartDate(), "h:mm a");
		    endTime=CommonUtility.dateToString(getEndDate(), "h:mm a");
	   }catch(Exception e){
		   
	   }
	   if(beginTime != null && endTime != null){
		   time=beginTime + " to " + endTime; 
	   }
	   return time;	
	}
	
	@JsonIgnore
	public String getDisplayTaskTime(){
	   String time=null;	
	   String beginTime=null;
	   String endTime=null;
	   if(isAllDay()){
		   if(getEventType().equals("My Tasks")){
			   return "12:00AM"; 
		   }
	   }
	   try{
		    beginTime=CommonUtility.dateToString(getStartDate(), "h:mm a");
		    endTime=CommonUtility.dateToString(getEndDate(), "h:mm a");
	   }catch(Exception e){
		   
	   }
	   if(beginTime != null && endTime != null){
		   time=beginTime + " to " + endTime; 
	   }
	   return time;	
	}

	
	
	
	@JsonIgnore
	public String getDisplayDate(){
		return CommonUtility.dateToString(getStartDate(), "MM/dd/yyy");
	}
	
	@JsonIgnore
	public String getDisplayEventListDate(){
		return CommonUtility.dateToString(getStartDate(), "MM/dd");
	}
	
	@JsonIgnore
	public String getDisplayDay(){
		return CommonUtility.dateToString(getStartDate(), "EEE");
	}
	
	@JsonIgnore
	public String getDisplayTaskEndDate(){
		String endDate=null;
		if(getFinishDate() == null){
			endDate="No End Date (Ongoing)" ;
		}else{
			endDate=CommonUtility.dateToString(getFinishDate(), "MM/dd/yyy");
		}
		return endDate;
	}

	
	
	@JsonIgnore
	public HourEnumeration[] getHours() {
		return HourEnumeration.values();
	}
	
	@JsonIgnore
	public MinuteEnumeration[] getMinutes() {
		return MinuteEnumeration.values();
	}
	
	public String getEventName() {
		return eventName;
	}
	public void setEventName(String eventName) {
		this.eventName = eventName;
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getRepeatInterval() {
		return repeatInterval;
	}
	public void setRepeatInterval(String repeatInterval) {
		this.repeatInterval = repeatInterval;
	}
	public Date getRepeatEndDate() {
		return repeatEndDate;
	}
	public void setRepeatEndDate(Date repeatEndDate) {
		this.repeatEndDate = repeatEndDate;
	}
	public String getClinic() {
		return clinic;
	}
	public void setClinic(String clinic) {
		this.clinic = clinic;
	}
	public String getClinicPhone() {
		return clinicPhone;
	}
	public void setClinicPhone(String clinicPhone) {
		this.clinicPhone = clinicPhone;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public String getTime() {
		return time;
	}
	public void setTime(String time) {
		this.time = time;
	}
	public String getEventType() {
		return eventType;
	}
	public void setEventType(String eventType) {
		this.eventType = eventType;
	}
	public Long getEventId() {
		return eventId;
	}
	public void setEventId(Long eventId) {
		this.eventId = eventId;
	}
	public Date getFinishDate() {
		return finishDate;
	}
	public void setFinishDate(Date finishDate) {
		this.finishDate = finishDate;
	}
	public Date getBeginDate() {
		return beginDate;
	}
	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}
	public String getStartHour() {
		return startHour;
	}
	public void setStartHour(String startHour) {
		this.startHour = startHour;
	}
	public String getStartMinute() {
		return startMinute;
	}
	public void setStartMinute(String startMinute) {
		this.startMinute = startMinute;
	}
	public String getEndHour() {
		return endHour;
	}
	public void setEndHour(String endHour) {
		this.endHour = endHour;
	}
	public String getEndMinute() {
		return endMinute;
	}
	public void setEndMinute(String endMinute) {
		this.endMinute = endMinute;
	}
	
}
